<?php

declare(strict_types=1);

namespace Fixtures;

use Mage;
use Varien_Object;
use Crossroads\Magento\Test\Integration\MagentoManager;

class Labels {
    public function load(): void {
        if( ! class_exists("Crossroads_ImprovedAttributeValues_Helper_Image", false)) {
            class_alias("Fixtures\\ImageHelper", "Crossroads_ImprovedAttributeValues_Helper_Image");
        }

        MagentoManager::initAdmin();

        $labels = [];
        $labelIds = [];
        $descriptions = [];
        $descriptionIds = [];
        $media = [];
        $descMedia = [];
        $option = [
            "delete" => [],
            "value" => [],
        ];
        $attr = Mage::getModel("catalog/entity_attribute")->loadByCode("catalog_product", "manufacturer");
        $attrData = Mage::getModel('catalog/resource_eav_attribute')->load($attr->getId());

        $attrOptions = $attrData->getSource()->getAllOptions();

        foreach($attrOptions as $o) {
            if(empty($o["value"])) {
                continue;
            }

            $labelIds[$o["value"]][0] = $this->getId($o["value"]);
            $labels[$o["value"]] = [
                // Global
                0 => sprintf("Attribute '%s'.", $o["label"]),
            ];
            $media[$o["value"]] = [
                // Global
                0 => sprintf("/attr/%s.png", $o["label"]),
            ];
            $descriptions[$o["value"]] = [
                // Global
                0 => sprintf("Attribute '%s' Description.", $o["label"]),
            ];
            $descriptionIds[$o["value"]][0] = $this->getDescId($o["value"]);
            $descMedia[$o["value"]] = [
                // Global
                0 => sprintf("/attr/desc_%s.png", $o["label"]),
            ];
            $option["value"][$o["value"]] = true;
        }

        $attrData->setIavIconIds($labelIds);
        $attrData->setIavIconLabels($labels);
        $attrData->setIavIconMedia($media);
        $attrData->setIavDescriptionIds($descriptionIds);
        $attrData->setIavDescriptions($descriptions);
        $attrData->setIavDescriptionMedia($descMedia);
        $attrData->setOption($option);

        // WTF Magento! It does not load event config properly
        Mage::getSingleton("improvedattributevalues/resource_option_label")->attributeSaveAfter(new Varien_Object([
            "data_object" => $attrData,
        ]));
        Mage::getSingleton("improvedattributevalues/resource_option_description")->attributeSaveAfter(new Varien_Object([
            "data_object" => $attrData,
        ]));

        MagentoManager::reset();
    }

    public function getId($labelValue): ?string {
        $db = Mage::getSingleton('core/resource')->getConnection("core_write");

        $data = $db->query("SELECT label_id FROM crossroads_iav_option_label WHERE option_id = ?", [$labelValue])->fetchAll();

        return $data[0]["label_id"] ?? null;
    }

    public function getDescId($labelValue): ?string {
        $db = Mage::getSingleton('core/resource')->getConnection("core_write");

        $data = $db->query("SELECT description_id FROM crossroads_iav_option_description WHERE option_id = ?", [$labelValue])->fetchAll();

        return $data[0]["description_id"] ?? null;
    }
}
