<?php

class Crossroads_ImprovedAttributeValues_Block_Adminhtml_Catalog_Product_Attribute_Edit_Tab_Descriptions extends Mage_Adminhtml_Block_Widget {
    public function __construct()
    {
        parent::__construct();
        $this->setTemplate('crossroads_iav/attribute/descriptions.phtml');
    }

    /**
     * Retrieve stores collection with default store
     *
     * @return Mage_Core_Model_Mysql4_Store_Collection
     */
    public function getStores()
    {
        $stores = $this->getData('stores');
        if (is_null($stores)) {
            $stores = Mage::getModel('core/store')
                ->getResourceCollection()
                ->setLoadDefault(true)
                ->load();
            $this->setData('stores', $stores);
        }
        return $stores;
    }

    public function getOptionDescriptions() {
        return Mage::getResourceModel("improvedattributevalues/option_description")
            ->getAttributeDescriptions(Mage::registry("entity_attribute"));
    }
}
