<?php

class Crossroads_ImprovedAttributeValues_Block_Adminhtml_Catalog_Product_Attribute_Edit_Tab extends Mage_Adminhtml_Block_Widget {
    /**
     * Retrieve stores collection with default store
     *
     * @return Mage_Core_Model_Mysql4_Store_Collection
     */
    public function getStores()
    {
        $stores = $this->getData('stores');
        $currentStore = $this->getRequest()->getParam('store', 0);
        if (is_null($stores)) {
            $stores = Mage::getResourceModel('core/store_collection');

            $stores->setLoadDefault(true);
            $stores->addIdFilter($currentStore);
            $stores->load();

            $this->setData('stores', $stores->getItems());
        }
        return $stores;
    }

    public function getOptionDescriptions() {
        return Mage::getResourceModel("improvedattributevalues/option_description")
            ->getAttributeDescriptions(Mage::registry("entity_attribute"));
    }

    public function getOptionLabels() {
        return Mage::getResourceModel("improvedattributevalues/option_label")
            ->getAttributeLabels(Mage::registry("entity_attribute"));
    }
}
