<?php

$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$table = $conn->newTable($installer->getTable("improvedattributevalues/option_label_index"))
    ->addColumn("label_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "identity"       => true,
        "unsigned"       => true,
        "nullable"       => false,
        "primary"        => true,
    ])
    ->addColumn("data", Varien_Db_Ddl_Table::TYPE_TEXT, null, [
        "nullable" => false,
    ])
    ->addColumn("created_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        "nullable" => false,
        "default"  => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
    ])
    ->addColumn("updated_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        "nullable" => false,
        "default"  => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
    ])
    ->addForeignKey(
        $installer->getFkName(
            "improvedattributevalues/option_label_index",
            "label_id",
            "improvedattributevalues/option_label",
            "label_id"
        ),
        "label_id", $installer->getTable("improvedattributevalues/option_label"), "label_id",
        Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE)
    ->setOption("type", "InnoDB")
    ->setOption("charset", "utf8");

$conn->createTable($table);

$installer->endSetup();
