<?php

class Crossroads_ImprovedAttributeValues_Attribute_ValuesController extends Crossroads_API_Controller_Resource {
    public function getAll() {
        return [404];
    }

    public function getItem($id) {
        $store       = Mage::app()->getStore();
        $req         = $this->getRequest();
        $image       = Mage::helper("improvedattributevalues/image");
        $config      = Mage::getSingleton("improvedattributevalues/media_config");
        $inlineMedia = strtolower(trim($req->getQuery("inlineMedia"))) === "true";
        $resource    = Mage::getResourceModel("improvedattributevalues/option_label");
        $rows        = $resource->getLabels($store->getId(), "catalog_product", $id, $inlineMedia);
        $data        = [];

        foreach($rows as $row) {
            $data[$row["value"]] = [
                "title"    => $row["title"],
                "icon"     => $row["media"] ? $image->resizeIcon($row["media"]) : null,
                "original" => $config->getMediaUrl($row["media"]),
                "dataUrl"  => empty($row["dataUrl"]) ? null : $row["dataUrl"],
            ];
        }

        return [200, $data];
    }
}
