<?php

class Crossroads_ImprovedAttributeValues_Adminhtml_Improvedattributevalues_UploadController extends Mage_Adminhtml_Controller_Action {
    // Allow calls without form key
    protected function _validateFormKey() {
        return true;
    }

    public function uploadAction() {
        try {
            $uploader = new Mage_Core_Model_File_Uploader("image");
            $uploader->setAllowedExtensions(array("jpg","jpeg","gif","png"));
            $uploader->addValidateCallback("improvedattributevalues_image",
                Mage::helper("catalog/image"), "validateUploadFile");
            $uploader->setAllowRenameFiles(true);
            $uploader->setFilesDispersion(true);
            $uploader->addValidateCallback(
                Mage_Core_Model_File_Validator_Image::NAME,
                Mage::getModel("core/file_validator_image"),
                "validate"
            );
            $result = $uploader->save(
                Mage::getSingleton("improvedattributevalues/media_config")->getBaseTmpMediaPath()
            );

            /**
             * Workaround for prototype 1.7 methods "isJSON", "evalJSON" on Windows OS
             */
            $result["tmp_name"] = str_replace(DS, "/", $result["tmp_name"]);
            $result["path"] = str_replace(DS, "/", $result["path"]);

            $result["url"] = Mage::getSingleton("improvedattributevalues/media_config")
                ->getTmpMediaUrl($result["file"]);
            $result["file"] = $result["file"];
            $result["cookie"] = array(
                "name"     => session_name(),
                "value"    => $this->_getSession()->getSessionId(),
                "lifetime" => $this->_getSession()->getCookieLifetime(),
                "path"     => $this->_getSession()->getCookiePath(),
                "domain"   => $this->_getSession()->getCookieDomain()
            );
        }
        catch(Exception $e) {
            $result = array(
                "error" => $e->getMessage(),
                "errorcode" => $e->getCode());
        }

        $this->getResponse()->setBody(Mage::helper("core")->jsonEncode($result));
    }
}
