<?php

class Crossroads_ImprovedAttributeValues_Model_Observer {
    protected $data = null;

    public function __construct() {
        $this->data = Mage::getResourceModel("improvedattributevalues/option_label")->getLabels(Mage::app()->getStore()->getId(), "catalog_product");
    }

    public function listProductPrepare($event) {
        $data = $event->getPreparedData();

        $data->setData("attributeLabels", $this->loadAttrs($data["attributes"]));
    }

    public function cartProductPrepare($event) {
        $data    = $event->getPreparedData();
        $product = $data["product"];

        $product["attributeLabels"] = $this->loadAttrs($product["attributes"]);

        $data->setData("product", $product);
    }

    protected function loadAttrs($attributes) {
        $image = Mage::helper("improvedattributevalues/image");
        $attrs = [];

        foreach($attributes as $k => $v) {
            foreach($this->data as $d) {
                if($k === $d["attribute_code"]) {
                    if( ! array_key_exists($k, $attrs)) {
                        $attrs[$k] = [];
                    }

                    if(is_array($v) && in_array($d["value"], $v) || $v === $d["value"]) {
                        $attrs[$k] = array_merge($attrs[$k], [[
                            "title" => $d["title"],
                            "icon"  => $d["media"] ? $image->resizeIcon($d["media"]) : null,
                        ]]);
                    }
                }
            }
        }

        return $attrs ?: new stdClass;
    }

    public function productDetailPrepare($event) {
        $product = $event->getProduct();
        $data    = $event->getPreparedData();
        $descs   = Mage::getResourceModel("improvedattributevalues/option_description")
            ->getProductDescriptions($product, Mage::app()->getStore()->getStoreId()) ?: new stdClass;

        $data->setData("attributeDescriptions", $descs);
    }
}
