<?php

$installer = $this;
$setup = Mage::getResourceModel("catalog/setup", "catalog_setup");
$entityTypeId = (int) Mage::getModel("catalog/product")->getResource()->getEntityType()->getId();
$DefaultAttributeSetId = (int) $installer->getEntityTypeId("catalog_product", "Default");

$installer->startSetup();
$conn = $installer->getConnection();

$attributeSetName = "Goyada";
$attributeGroupName = "Goyada";

// https://makandracards.com/magento/6721-product-attribute-addition
$newAttributes = array(
    Crossroads_Goyada_Helper_Data::GOYADA_DESIGN_DATA => array(
        "label" => "Goyada design key/values",
        "group" => "",
        "sort_order" => 5,
        "backend" => "Crossroads_Goyada/product_arrayinput",
        "type" => "text",
        "frontend" => "",
        "note" => "<p class=\"note\">key/value pairs used for email design changes.</p>",
        "default" => 0,
        "wysiwyg_enabled" => false,
        "input" => "textarea",
        "input_renderer" => "",
        "source" => "",
        "required" => false,
        "user_defined" => false,
        "unique" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "visible" => true,
        "visible_on_front" => true,
        "used_in_product_listing" => true,
        "searchable" => false,
        "visible_in_advanced_search" => false,
        "filterable" => false,
        "filterable_in_search" => false,
        "comparable" => false,
        "is_html_allowed_on_front" => false,
        "apply_to" => "bundle,virtual",
        "is_configurable" => false,
        "used_for_sort_by" => false,
        "position" => 0,
        "used_for_promo_rules" => false,
    ),
);

// Fetch id for attribute set
$attributeSetId = $this->getAttributeSetId($entityTypeId, $attributeSetName);

// Add all new attributes
$attributeWasAdded = false;
foreach ($newAttributes as $attributeName => $attributeData) {

    // Check if attribute already exists
    if (!$setup->getAttributeId(Mage_Catalog_Model_Product::ENTITY, $attributeName)) {

        // Add attribute
        $setup->addAttribute(Mage_Catalog_Model_Product::ENTITY, $attributeName, $attributeData);
        $attributeWasAdded = true;

        // Add new attribute to new attribute set using new attribute group
        $setup->addAttributeToSet($entityTypeId, $attributeSetId, $attributeGroupName, $attributeName, $attributeData["sort_order"]);
    }
}

// If at least one attribute was added, do some cleanup and setup.
if ($attributeWasAdded) {

    // This removes new attributes from all attribute sets EXCEPT the newly created one.
    if (!empty($attributeSetId)) {
        $sqlQuery1 = "DELETE FROM eav_entity_attribute WHERE attribute_set_id != :attributeSetId AND attribute_id IN (SELECT attribute_id FROM eav_attribute WHERE attribute_code LIKE '%goyada%')";
        $stm1 = Mage::getSingleton("core/resource")->getConnection("core_setup")->prepare($sqlQuery1);
        $stm1->execute(["attributeSetId" => $attributeSetId]);
    }

    // Having problems with is_user_defined not beeing set. This fixes that.
    $sqlQuery2 = "UPDATE eav_attribute SET is_user_defined = 1 WHERE attribute_code LIKE '%goyada%'";
    $stm2 = Mage::getSingleton("core/resource")->getConnection("core_setup")->prepare($sqlQuery2);
    $stm2->execute();
}

$installer->endSetup();
