<?php

class Crossroads_Goyada_Model_Resource_Voucher_Collection extends Mage_Core_Model_Resource_Db_Collection_Abstract {

    protected function _construct()
    {
        parent::_construct();

        $this->_init("Crossroads_Goyada/voucher");
    }

    public function addItemFilter($itemId)
    {
        $this->getSelect()->joinLeft(
                ["voucher_image" => "crossroads_goyada_voucher_image"],
                "main_table.entity_id = voucher_image.voucher_id",
                ["image_hash"]
        );
        $this->getSelect()->where("main_table.item_id = ?", $itemId);

        return $this;
    }

    public function addOrderFilter($orderId)
    {
        $this->getSelect()->join(
                ["sfoi" => "sales_flat_order_item"],
                "main_table.item_id = sfoi.item_id",
                ["order_id" => "parent_id"]
        );
        $this->getSelect()->where("sfoi.parent_id = ?", $orderId);

        return $this;
    }

    public function addCodeFilter($code = null)
    {
        if (is_null($code)) {
            $this->getSelect()->where("main_table.voucher_code is not null");
        } elseif(is_string($code)) {
            $this->getSelect()->where("main_table.voucher_code = ?", $code);
        }

        return $this;
    }

}
