<?php

class Crossroads_Goyada_Model_Product_Email_Template extends Mage_Eav_Model_Entity_Attribute_Source_Abstract {

    public function getAllOptions()
    {
        if (!$this->_options) {
            $default = $this->getAttribute()->getDefaultValue();
            $this->_options[0]["value"] = $default;
            $this->_options[0]["label"] = "Default Template from Locale";
            $template_collection = Mage::getResourceSingleton("core/email_template_collection");
            if ($template_collection) {
                $i = 1;
                foreach ($template_collection as $template) {
                    $tempid = $template->getTemplateId();
                    $tempcode = $template->getTemplateCode();
                    $this->_options[$i]["value"] = $tempid;
                    $this->_options[$i]["label"] = $tempcode;
                    $i++;
                }
            }
        }
        return $this->_options;
    }

    public function toOptionArray()
    {
        $_options = array();
        if ($this->getAllOptions()) {
            foreach ($this->getAllOptions() as $option) {
                $_options[$option["value"]] = $option["label"];
            }
        }
        return $_options;
    }

}
