<?php

class Crossroads_Goyada_Model_Observer extends Mage_Core_Model_Abstract {

    protected $_helper = null;

    public function getHelper()
    {
        if (empty($this->_helper)) {
            $this->_helper = Mage::helper("Goyada");
        }
        return $this->_helper;
    }

    public function issueVoucherEvent(Varien_Event_Observer $observer)
    {
        $order = $observer->getOrder();
        if (empty($order)) {
            return;
        }

        $orderId = $order->getId();
        if (empty($orderId)) {
            return;
        }

        // Make sure we only issue vouchers for orders with correct status.
        if (!in_array($order->getStatus(), Crossroads_Goyada_Helper_Data::$issueVoucherOrderStatuses)) {
            return;
        }

        // Only process orders that actually contain Goyada products
        $orderData = $this->getHelper()->getOrderData($orderId);
        if (empty($orderData)) {
            return;
        }

        $storeId = $order->getStoreId();
        // If issueVoucherEvent() is triggered by script or other method, make sure we use same store context as order.
        $emulate = $storeId != Mage::app()->getStore()->getId();

        // We need this to fetch correct data for emails
        if ($emulate) {
            $appEmulation = Mage::getSingleton("core/app_emulation");
            $initialEnvironmentInfo = $appEmulation->startEnvironmentEmulation($storeId);
        }

        try {
            $this->getHelper()->purchaseVoucher($order);
            $this->getHelper()->sendCustomerEmailForOrder($order);
        } catch (Exception $ex) {
            Mage::logException($ex);
            // ToDo: Perhaps send email about this?
        }

        $comment = Mage::registry("goyada_order_comment");
        if (!empty($comment)) {

            // Normally issueVoucherEvent() is triggered by customer
            $username = "customer";
            $adminSession = Mage::getSingleton("admin/session");
            if ($adminSession) {
                $adminUser = $adminSession->getUser();
                if ($adminUser) {
                    $username = $adminUser->getUsername();
                }
            }

            $history = $order->addStatusHistoryComment("issueVoucherEvent was triggered by {$username}\n" . $comment);
            $history->setIsCustomerNotified(Mage_Sales_Model_Order_Status_History::CUSTOMER_NOTIFICATION_NOT_APPLICABLE);
            $order->save();
        }

        if ($emulate) {
            $appEmulation->stopEnvironmentEmulation($initialEnvironmentInfo);
        }
    }

    public function serializeValues(Varien_Event_Observer $observer)
    {
        $form = $observer->getEvent()->getForm();

        $element1 = $form->getElement(Crossroads_Goyada_Helper_Data::GOYADA_API_DATA);
        if ($element1) {
            $element1->setRenderer(Mage::app()->getLayout()->createBlock('Goyada/Adminhtml_Renderer_Arrayinput'));
        }

        $element2 = $form->getElement(Crossroads_Goyada_Helper_Data::GOYADA_DESIGN_DATA);
        if ($element2) {
            $element2->setRenderer(Mage::app()->getLayout()->createBlock('Goyada/Adminhtml_Renderer_Arrayinput'));
        }
    }

}
