<?php

class Crossroads_Goyada_Adminhtml_Goyada_ItemsController extends Mage_Adminhtml_Controller_Action {

    protected function _isAllowed()
    {
        $action = strtolower($this->getRequest()->getActionName());
        switch ($action) {
            case "issue":
                return Mage::getSingleton('admin/session')->isAllowed(Crossroads_Goyada_Helper_Data::GOYADA_ACL_ORDER_ITEM_ISSUE);
            case "email":
                return Mage::getSingleton('admin/session')->isAllowed(Crossroads_Goyada_Helper_Data::GOYADA_ACL_ORDER_ITEM_EMAIL);
            default:
                Mage::getSingleton('adminhtml/session')->addError("Missing acl-check for {$action}");
                return true;
        }
    }

    public function getHelper()
    {
        if (empty($this->_helper)) {
            $this->_helper = Mage::Helper("Goyada");
        }
        return $this->_helper;
    }

    public function issueAction()
    {
        $pid = $this->getRequest()->getParam("id");
        $order = Mage::getSingleton("sales/order")->load($pid);
        $itemIds = explode(",", $this->getRequest()->getPost("goyada_items"));

        if (empty($itemIds)) {
            Mage::getSingleton("adminhtml/session")->addError("Missing items");
        } else {
            try {
                $this->getHelper()->purchaseVoucher($order, $itemIds);
            } catch (Exception $ex) {
                Mage::getSingleton("adminhtml/session")->addError("Exception: {$ex->getMessage()}");
            }

            $comment = Mage::registry("goyada_order_comment");
            if (!empty($comment)) {
                $adminUsername = "admin";
                $adminSession = Mage::getSingleton("admin/session");
                if ($adminSession) {
                    $adminUser = $adminSession->getUser();
                    if ($adminUser) {
                        $adminUsername = $adminUser->getUsername();
                    }
                }
                $history = $order->addStatusHistoryComment("Order was updated by {$adminUsername}\n" . $comment);
                $history->setIsCustomerNotified(Mage_Sales_Model_Order_Status_History::CUSTOMER_NOTIFICATION_NOT_APPLICABLE);
                $order->save();
                Mage::getSingleton("adminhtml/session")->addSuccess($comment);
            }
        }

        $this->_redirect("adminhtml/sales_order/view", array("order_id" => $pid));
    }

    public function emailAction()
    {
        $pid = $this->getRequest()->getParam("id");
        $order = Mage::getSingleton("sales/order")->load($pid);
        $storeId = $order->getStoreId();
        $itemIds = explode(",", $this->getRequest()->getPost("goyada_items"));

        $appEmulation = Mage::getSingleton("core/app_emulation");
        $initialEnvironmentInfo = $appEmulation->startEnvironmentEmulation($storeId);

        try {
            $itemList = $this->getHelper()->getVoucherItemList($order);
            foreach ($itemList as $itemId => $itemData) {
                if (in_array($itemId, $itemIds)) {
                    $codes = Mage::getModel("Crossroads_Goyada/voucher")->getCollection()->addItemFilter($itemId)->addCodeFilter();
                    $codeQty = count($codes);
                    if ($codeQty > 0) {
                        $this->getHelper()->sendCustomerEmailForItem($order, $itemData);
                    }
                }
            }
        } catch (Exception $ex) {
            Mage::getSingleton("adminhtml/session")->addError("Exception: {$ex->getMessage()}");
        }

        $comment = Mage::registry("goyada_order_comment");
        if (!empty($comment)) {
            $adminUsername = "admin";
            $adminSession = Mage::getSingleton("admin/session");
            if ($adminSession) {
                $adminUser = $adminSession->getUser();
                if ($adminUser) {
                    $adminUsername = $adminUser->getUsername();
                }
            }
            $history = $order->addStatusHistoryComment("Order was updated by {$adminUsername}\n" . $comment);
            $history->setIsCustomerNotified(Mage_Sales_Model_Order_Status_History::CUSTOMER_NOTIFICATION_NOT_APPLICABLE);
            $order->save();
            Mage::getSingleton("adminhtml/session")->addSuccess($comment);
        }

        $appEmulation->stopEnvironmentEmulation($initialEnvironmentInfo);
        $this->_redirect("adminhtml/sales_order/view", array("order_id" => $pid));
    }

}
