<?php

class Crossroads_Goyada_Model_Product_Arrayinput extends Mage_Eav_Model_Entity_Attribute_Backend_Abstract {

    /*
     * input from html form is named as:
     *     <attribute>[<id>][key]
     *     <attribute>[<id>][val]
     */
    public function beforeSave($object)
    {
        // Before saving the product check if the attribute `custom_values` is array.
        // If it is, reindex and serialize it for saving in the db
        $attributeCode = $this->getAttribute()->getAttributeCode();
        $data = $object->getData($attributeCode);
        if (is_array($data)) {
            array_splice($data, 0, 0); // Reindex array
            $object->setData($attributeCode, serialize($data));
        }
        return parent::beforeSave($object);
    }

    public function afterLoad($object)
    {
        // After loading the product, check if the value for custom_values is not an array.
        // If it's not try to unserialize the value.
        $attributeCode = $this->getAttribute()->getAttributeCode();
        $data = $object->getData($attributeCode);
        if (!is_array($data)) {
            $object->setData($attributeCode, @unserialize($data));
        }
        return parent::afterLoad($object);
    }

}
