<?php

class Crossroads_Goyada_Block_Adminhtml_Vouchers extends Mage_Adminhtml_Block_Template
{
    public function getVouchers()
    {
        if (!Mage::getSingleton('admin/session')->isAllowed(Crossroads_Goyada_Helper_Data::GOYADA_ACL_ORDER_ITEM_LIST)) {
            return [];
        }

        $order = Mage::registry("sales_order");
        return Mage::helper("Goyada")->getVoucherItemList($order);
    }

    public function getCodes($itemId)
    {
        $parsedCodes = [];

        $codes = Mage::getModel("Crossroads_Goyada/voucher")->getCollection()->addItemFilter($itemId)->addCodeFilter();
        foreach ($codes as $code) {

            $voucherData = $code["voucher_data"];
            if (!empty($voucherData)) {
                $voucherData = json_decode($voucherData, true);
            }
            if (empty($voucherData)) {
                $voucherData = [];
            }

            $parsedCodes[$code["entity_id"]] = [
                "item_id" => $code["item_id"],
                "voucher_action" => $code["voucher_action"],
                "voucher_product_id" => $code["voucher_product_id"],
                "voucher_data" => $voucherData,
                "voucher_code" => $code["voucher_code"],
                "valid_to" => $code["valid_to"],
                "created_at" => $code["created_at"],
                "sent_at" => $code["sent_at"],
                "api_url" => $code["api_url"],
                "api_result" => $code["api_result"]
            ];
        }

        return $parsedCodes;
    }

    public function getVoucherDataAsString($voucherData) {

        $voucherDataString = "";
        foreach ($voucherData as $kv) {
            $voucherDataString .= !empty($voucherDataString) ? ", " : "";
            $voucherDataString .= "{$kv["key"]} = {$kv["val"]}";
        }

        return $voucherDataString;

    }

}