<?php

$installer = $this;
$setup = Mage::getResourceModel("catalog/setup", "catalog_setup");
$entityTypeId = (int) Mage::getModel("catalog/product")->getResource()->getEntityType()->getId();
$DefaultAttributeSetId = (int) $installer->getEntityTypeId("catalog_product", "Default");

$installer->startSetup();
$conn = $installer->getConnection();

$installer->run("
    ALTER TABLE `crossroads_goyada_voucher`
        ADD COLUMN `voucher_data` MEDIUMTEXT NULL DEFAULT NULL COMMENT 'Voucher data, JSON' COLLATE 'utf8_general_ci' AFTER `voucher_product_id`,
        DROP COLUMN `voucher_value`;
");

$attributeSetName = "Goyada";
$attributeGroupName = "Goyada";
$attributeSetId = $this->getAttributeSetId($entityTypeId, $attributeSetName);

// https://magento.stackexchange.com/questions/38434/adminhtml-how-to-add-custom-template-for-custom-product-attribute
$newAttributes = array(
    Crossroads_Goyada_Helper_Data::GOYADA_API_TEST_SERVICE => array(
        "label" => "Goyada API action (test)",
        "group" => "",
        "sort_order" => 10,
        "backend" => "",
        "type" => "varchar",
        "frontend" => "",
        "note" => "",
        "default" => "",
        "wysiwyg_enabled" => false,
        "input" => "text",
        "input_renderer" => "",
        "source" => "",
        "required" => false,
        "user_defined" => false,
        "unique" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "visible" => true,
        "visible_on_front" => true,
        "used_in_product_listing" => false,
        "searchable" => false,
        "visible_in_advanced_search" => false,
        "filterable" => false,
        "filterable_in_search" => false,
        "comparable" => false,
        "is_html_allowed_on_front" => false,
        "apply_to" => "virtual",
        "is_configurable" => false,
        "used_for_sort_by" => false,
        "position" => 0,
        "used_for_promo_rules" => false,
    ),
    Crossroads_Goyada_Helper_Data::GOYADA_API_DATA => array(
        "label" => "Goyada API key/values",
        "group" => $attributeGroupName,
        "sort_order" => 1,
        "backend" => "Crossroads_Goyada/product_arrayinput",
        "type" => "text",
        "frontend" => "",
        "note" => "",
        "default" => 0,
        "wysiwyg_enabled" => false,
        "input" => "textarea",
        "input_renderer" => "",
        "source" => "",
        "required" => false,
        "user_defined" => false,
        "unique" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "visible" => true,
        "visible_on_front" => true,
        "used_in_product_listing" => true,
        "searchable" => false,
        "visible_in_advanced_search" => false,
        "filterable" => false,
        "filterable_in_search" => false,
        "comparable" => false,
        "is_html_allowed_on_front" => false,
        "apply_to" => "bundle,virtual",
        "is_configurable" => false,
        "used_for_sort_by" => false,
        "position" => 0,
        "used_for_promo_rules" => false,
    )
);



// Add all new attributes
foreach ($newAttributes as $attributeName => $attributeData) {

    // Check if attribute already exists
    if (!$setup->getAttributeId(Mage_Catalog_Model_Product::ENTITY, $attributeName)) {

        // Add attribute
        $setup->addAttribute(Mage_Catalog_Model_Product::ENTITY, $attributeName, $attributeData);

        // Add new attribute to attribute set using attribute group
        $setup->addAttributeToSet($entityTypeId, $attributeSetId, $attributeGroupName, $attributeName, $attributeData["sort_order"]);
    }
}

// Remove obsolete product attribute
$setup->removeAttribute(Mage_Catalog_Model_Product::ENTITY, "goyada_voucher_value");

$installer->endSetup();
