<?php

$installer = $this;
$setup = Mage::getResourceModel("catalog/setup", "catalog_setup");
$entityTypeId = (int) Mage::getModel("catalog/product")->getResource()->getEntityType()->getId();
$DefaultAttributeSetId = (int) $installer->getEntityTypeId("catalog_product", "Default");

$installer->startSetup();
$conn = $installer->getConnection();

$newAttributeSetId = 0;
$newAttributeSetName = "Goyada";
$newAttributeGroupName = "Goyada";

// https://makandracards.com/magento/6721-product-attribute-addition
$newAttributes = array(
    Crossroads_Goyada_Helper_Data::GOYADA_PRODUCT => array(
        "label" => "Activate Goyada processing",
        "group" => "",
        "sort_order" => 1,
        "backend" => "",
        "type" => "int",
        "frontend" => "",
        "note" => "",
        "default" => 0,
        "wysiwyg_enabled" => false,
        "input" => "select",
        "input_renderer" => "",
        "source" => "eav/entity_attribute_source_boolean",
        "required" => false,
        "user_defined" => false,
        "unique" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "visible" => true,
        "visible_on_front" => true,
        "used_in_product_listing" => true,
        "searchable" => false,
        "visible_in_advanced_search" => false,
        "filterable" => false,
        "filterable_in_search" => false,
        "comparable" => false,
        "is_html_allowed_on_front" => false,
        "apply_to" => "bundle,virtual",
        "is_configurable" => false,
        "used_for_sort_by" => false,
        "position" => 0,
        "used_for_promo_rules" => false,
    ),
    Crossroads_Goyada_Helper_Data::GOYADA_PRODUCT_ID => array(
        "label" => "Goyada product ID",
        "group" => "",
        "sort_order" => 2,
        "backend" => "",
        "type" => "varchar",
        "frontend" => "",
        "note" => "",
        "default" => "",
        "wysiwyg_enabled" => false,
        "input" => "text",
        "input_renderer" => "",
        "source" => "",
        "required" => false,
        "user_defined" => false,
        "unique" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "visible" => true,
        "visible_on_front" => true,
        "used_in_product_listing" => false,
        "searchable" => false,
        "visible_in_advanced_search" => false,
        "filterable" => false,
        "filterable_in_search" => false,
        "comparable" => false,
        "is_html_allowed_on_front" => false,
        "apply_to" => "virtual",
        "is_configurable" => false,
        "used_for_sort_by" => false,
        "position" => 0,
        "used_for_promo_rules" => false,
    ),
    Crossroads_Goyada_Helper_Data::GOYADA_VOUCHER_VALUE => array(
        "label" => "Actual value of voucher",
        "group" => "",
        "sort_order" => 7,
        "backend" => "",
        "type" => "decimal",
        "frontend" => "",
        "note" => "",
        "default" => 0,
        "wysiwyg_enabled" => false,
        "input" => "price",
        "input_renderer" => "",
        "source" => "",
        "required" => false,
        "user_defined" => false,
        "unique" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "visible" => true,
        "visible_on_front" => true,
        "used_in_product_listing" => false,
        "searchable" => false,
        "visible_in_advanced_search" => false,
        "filterable" => false,
        "filterable_in_search" => false,
        "comparable" => false,
        "is_html_allowed_on_front" => false,
        "apply_to" => "virtual",
        "is_configurable" => false,
        "used_for_sort_by" => false,
        "position" => 0,
        "used_for_promo_rules" => false,
    ),
    Crossroads_Goyada_Helper_Data::GOYADA_API_ACTION => array(
        "label" => "Goyada API action",
        "group" => "",
        "sort_order" => 9,
        "backend" => "",
        "type" => "varchar",
        "frontend" => "",
        "note" => "",
        "default" => "",
        "wysiwyg_enabled" => false,
        "input" => "text",
        "input_renderer" => "",
        "source" => "",
        "required" => false,
        "user_defined" => false,
        "unique" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "visible" => true,
        "visible_on_front" => true,
        "used_in_product_listing" => false,
        "searchable" => false,
        "visible_in_advanced_search" => false,
        "filterable" => false,
        "filterable_in_search" => false,
        "comparable" => false,
        "is_html_allowed_on_front" => false,
        "apply_to" => "virtual",
        "is_configurable" => false,
        "used_for_sort_by" => false,
        "position" => 0,
        "used_for_promo_rules" => false,
    ),
    Crossroads_Goyada_Helper_Data::GOYADA_EMAIL_TEMPLATE => array(
        "label" => "Delivery Email Template",
        "group" => "",
        "sort_order" => 14,
        "backend" => "",
        "type" => "varchar",
        "frontend" => "",
        "note" => "Template to use for delivering codes to customer.",
        "default" => "",
        "wysiwyg_enabled" => false,
        "input" => "select",
        "input_renderer" => "",
        "source" => "Crossroads_Goyada/Product_Email_Template",
        "required" => false,
        "user_defined" => false,
        "unique" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "visible" => true,
        "visible_on_front" => false,
        "used_in_product_listing" => false,
        "searchable" => false,
        "visible_in_advanced_search" => false,
        "filterable" => false,
        "filterable_in_search" => false,
        "comparable" => false,
        "is_html_allowed_on_front" => false,
        "apply_to" => "virtual",
        "is_configurable" => false,
        "used_for_sort_by" => false,
        "position" => 0,
        "used_for_promo_rules" => false,
    ),
    Crossroads_Goyada_Helper_Data::GOYADA_EMAIL_BCC => array(
        "label" => "Email Blind Copy To",
        "group" => "",
        "sort_order" => 15,
        "backend" => "",
        "type" => "varchar",
        "frontend" => "",
        "note" => "Separate each provided email address with comma.",
        "default" => "",
        "wysiwyg_enabled" => false,
        "input" => "text",
        "input_renderer" => "",
        "source" => "",
        "class" => "",
        "required" => false,
        "user_defined" => false,
        "unique" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "visible" => true,
        "visible_on_front" => false,
        "used_in_product_listing" => false,
        "searchable" => false,
        "visible_in_advanced_search" => false,
        "filterable" => false,
        "filterable_in_search" => false,
        "comparable" => false,
        "is_html_allowed_on_front" => false,
        "apply_to" => "virtual",
        "is_configurable" => false,
        "used_for_sort_by" => false,
        "position" => 0,
        "used_for_promo_rules" => false,
    ),
);

$installer->run("
    CREATE TABLE IF NOT EXISTS `crossroads_goyada_voucher` (
        `entity_id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'Voucher id',
        `item_id` INT(10) UNSIGNED NOT NULL COMMENT 'sales_flat_order_item id (child item)',
        `voucher_action` VARCHAR(50) NOT NULL COMMENT 'Goyada action' COLLATE 'utf8_general_ci',
        `voucher_product_id` VARCHAR(50) NOT NULL COMMENT 'Goyada product id' COLLATE 'utf8_general_ci',
        `voucher_value` DECIMAL(10,0) NOT NULL COMMENT 'Voucher value without fractions. 10kr becomes 1000, €12.34 becomes 1234, etc.',
        `voucher_code` VARCHAR(50) NULL DEFAULT NULL COMMENT 'Voucher code' COLLATE 'utf8_general_ci',
        `valid_to` DATE NULL DEFAULT NULL COMMENT 'Voucher valid until this date',
        `created_at` TIMESTAMP NOT NULL DEFAULT 'CURRENT_TIMESTAMP' COMMENT 'Created_at',
        `sent_at` TIMESTAMP NULL DEFAULT NULL COMMENT 'When voucher was sent to customer',
        `api_url` VARCHAR(255) NULL DEFAULT NULL COMMENT 'URL for API call to Goyada endpoint' COLLATE 'utf8_general_ci',
        `api_result` MEDIUMTEXT NULL DEFAULT NULL COMMENT 'Raw result from API call to Goyada endpoint' COLLATE 'utf8_general_ci',
        PRIMARY KEY (`entity_id`) USING BTREE,
        INDEX `IDX_CROSSROADS_GOYADA_VOUCHER_ITEM_ID` (`item_id`) USING BTREE,
        CONSTRAINT `FK_VOUCHER_ITEM_ID_ORDER_ITEM_ID` FOREIGN KEY (`item_id`) REFERENCES `sales_flat_order_item` (`item_id`) ON UPDATE CASCADE ON DELETE CASCADE
    )
    COMMENT='crossroads_goyada_voucher'
    COLLATE='utf8_general_ci'
    ENGINE=InnoDB;
");

$table1Name = $installer->getTable("Crossroads_Goyada/voucher");
$table1 = $conn->newTable($table1Name)
        ->addColumn(
                "entity_id",
                Varien_Db_Ddl_Table::TYPE_INTEGER,
                null,
                [
                    "auto_increment" => true,
                    "identity" => true,
                    "unsigned" => true,
                    "nullable" => false,
                    "primary" => true
                ],
                "Voucher id"
        )
        ->addColumn(
                "item_id",
                Varien_Db_Ddl_Table::TYPE_INTEGER,
                null,
                [
                    "unsigned" => true,
                    "nullable" => false
                ],
                "sales_flat_order_item id (child item)"
        )
        ->addColumn(
                "voucher_action",
                Varien_Db_Ddl_Table::TYPE_TEXT,
                50,
                [
                    "nullable" => false
                ],
                "Goyada action"
        )
        ->addColumn(
                "voucher_product_id",
                Varien_Db_Ddl_Table::TYPE_TEXT,
                50,
                [
                    "nullable" => false
                ],
                "Goyada product id"
        )
        ->addColumn(
                "voucher_value",
                Varien_Db_Ddl_Table::TYPE_DECIMAL,
                null,
                [
                    "nullable" => false,
                    "precision" => 10,
                    "scale" => 0
                ],
                "Voucher value without fractions. 10kr becomes 1000, €12.34 becomes 1234, etc."
        )
        ->addColumn(
                "voucher_code",
                Varien_Db_Ddl_Table::TYPE_TEXT,
                50,
                [
                    "nullable" => true,
                    "default" => null
                ],
                "Voucher code"
        )
        ->addColumn(
                "valid_to",
                Varien_Db_Ddl_Table::TYPE_DATE,
                null,
                [
                    "nullable" => true,
                    "default" => null
                ],
                "Voucher valid until this date"
        )
        ->addColumn(
                "created_at",
                Varien_Db_Ddl_Table::TYPE_TIMESTAMP,
                null,
                [
                    "nullable" => false,
                    "default" => Varien_Db_Ddl_Table::TIMESTAMP_INIT
                ]
        )
        ->addColumn(
                "sent_at",
                Varien_Db_Ddl_Table::TYPE_TIMESTAMP,
                null,
                [
                    "nullable" => true,
                    "default" => null
                ],
                "When voucher was sent to customer"
        )
        ->addColumn(
                "api_url",
                Varien_Db_Ddl_Table::TYPE_TEXT,
                255,
                [
                    "nullable" => true,
                    "default" => null
                ],
                "URL for API call to Goyada endpoint"
        )
        ->addColumn(
                "api_result",
                Varien_Db_Ddl_Table::TYPE_TEXT,
                65535,
                [
                    "nullable" => true,
                    "default" => null
                ],
                "Raw result from API call to Goyada endpoint"
        )
        ->addIndex(
                $installer->getIdxName("Crossroads_Goyada/voucher", "item_id", Varien_Db_Adapter_Interface::INDEX_TYPE_INDEX),
                "item_id",
                Varien_Db_Adapter_Interface::INDEX_TYPE_INDEX
        )
        ->addForeignKey(
                $installer->getFkName("Crossroads_Goyada/voucher", "item_id", "sales/order_item", "item_id"),
                "item_id",
                $installer->getTable("sales/order_item"),
                "item_id",
                Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE
        )
        ->setOption("type", "InnoDB")
        ->setOption("charset", "utf8");
$conn->createTable($table1);

/*
    CREATE TABLE `crossroads_goyada_voucher_image` (
        `voucher_id` INT(10) UNSIGNED NOT NULL COMMENT 'Voucher id',
        `image_hash` VARCHAR(32) NOT NULL COLLATE 'utf8_general_ci',
        `image_data` MEDIUMBLOB NOT NULL,
        PRIMARY KEY (`voucher_id`) USING BTREE,
        ADD CONSTRAINT `FK_crossroads_goyada_voucher_image_crossroads_goyada_voucher_1` FOREIGN KEY (`voucher_id`) REFERENCES `crossroads_goyada_voucher` (`entity_id`) ON UPDATE CASCADE ON DELETE CASCADE
    )
    COMMENT='crossroads_goyada_voucher_image'
    COLLATE='utf8_general_ci'
    ENGINE=InnoDB;
 */
$table2 = $conn->newTable($installer->getTable("Crossroads_Goyada/voucher_image"))
        ->addColumn(
                "voucher_id",
                Varien_Db_Ddl_Table::TYPE_INTEGER,
                null,
                [
                    "auto_increment" => false,
                    "identity" => true,
                    "unsigned" => true,
                    "nullable" => false,
                    "primary" => true
                ],
                "Voucher id"
        )
        ->addColumn(
                "image_hash",
                Varien_Db_Ddl_Table::TYPE_TEXT,
                null,
                [
                    "nullable" => false
                ],
                "Image data"
        )
        ->addColumn(
                "image_data",
                Varien_Db_Ddl_Table::TYPE_BLOB,
                null,
                [
                    "nullable" => false
                ],
                "Image data"
        )
        ->addForeignKey(
                $installer->getFkName("Crossroads_Goyada/voucher_image", "voucher_id", "Crossroads_Goyada/voucher", "entity_id"),
                "voucher_id",
                $installer->getTable("Crossroads_Goyada/voucher"),
                "entity_id",
                Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE
        )
        ->setOption("type", "InnoDB")
        ->setOption("charset", "utf8");
$conn->createTable($table2);

// Create new attribute set
$attributeSet = Mage::getModel("eav/entity_attribute_set")
        ->setEntityTypeId($entityTypeId)
        ->setAttributeSetName($newAttributeSetName);

if ($attributeSet->validate()) {
    // Need to save empty attribute set to be able to use its id further down the install process
    $attributeSet->save();

    // Add all attributes from default attribute set.
    $attributeSet->initFromSkeleton($DefaultAttributeSetId);

    // Now we can do a final save
    $attributeSet->save();

    // Fetch id for newly created attribute set
    $newAttributeSetId = $this->getAttributeSetId($entityTypeId, $newAttributeSetName);

    // Create new attribute group
    $setup->addAttributeGroup($entityTypeId, $newAttributeSetId, $newAttributeGroupName);

    // Add all new attributes
    foreach ($newAttributes as $attributeName => $attributeData) {

        // Check if attribute already exists
        if (!$setup->getAttributeId(Mage_Catalog_Model_Product::ENTITY, $attributeName)) {

            // Add attribute
            $setup->addAttribute(Mage_Catalog_Model_Product::ENTITY, $attributeName, $attributeData);

            // Add new attribute to new attribute set using new attribute group
            $setup->addAttributeToSet($entityTypeId, $newAttributeSetId, $newAttributeGroupName, $attributeName, $attributeData["sort_order"]);
        }
    }
} else {
    Mage::log("Attribute set with name '{$newAttributeSetName}' already exists.", LOG_ERR);
}

// This removes new attributes from all attribute sets EXCEPT the newly created one.
if (!empty($newAttributeSetId)) {
    $sqlQuery1 = "DELETE FROM eav_entity_attribute WHERE attribute_set_id != :attributeSetId AND attribute_id IN (SELECT attribute_id FROM eav_attribute WHERE attribute_code LIKE '%goyada%')";
    $stm1 = Mage::getSingleton("core/resource")->getConnection("core_setup")->prepare($sqlQuery1);
    $stm1->execute(["attributeSetId" => $newAttributeSetId]);
}

// Having problems with is_user_defined not beeing set. This fixes that.
$sqlQuery2 = "UPDATE eav_attribute SET is_user_defined = 1 WHERE attribute_code LIKE '%goyada%'";
$stm2 = Mage::getSingleton("core/resource")->getConnection("core_setup")->prepare($sqlQuery2);
$stm2->execute();

$installer->endSetup();
