<?php

use \Klarna\XMLRPC\Flags;

/**
 * Observer for Crossroads_Klarna module, separate class to make sure we only include this when
 * the event is triggered.
 */
class Crossroads_Fees_Model_KlarnaObserver extends Mage_Core_Model_Abstract {
    /**
     * Observes crossroads_klarna_invoice_reserve_amount_post_add_articles event to add
     * the payment fee to the Klarna invoice.
     *
     * @param  Varien_Event_Observer
     */
    public function invoiceReserveAmountPostAddArticles(Varien_Event_Observer $observer) {
        $order  = $observer->getOrder();
        $klarna = $observer->getKlarna();

        if($order->getBasePaymentFeeAmount()) {
            $taxRate = $order->getBasePaymentFeeTaxAmount() / $order->getBasePaymentFeeAmount() * 100;

            $klarna->addArticle(
                1,
                "payment_fee",
                $order->getPaymentFeeTitle(),
                $order->getBasePaymentFeeAmount(),
                $taxRate,
                0,
                // We skip Flags::INC_VAT because the amount above is excluding VAT
                Flags::IS_HANDLING
            );
        }
    }
}
