<?php

class Crossroads_Fees_Helper_Data extends Mage_Core_Helper_Abstract
{
    /**
     * Used in magento admin to always get a valid store. Falls back to Mage::app()->getStore() if
     * admin store or website is not set.
     *
     * @return Mage_Core_Model_Store
     */
    public function getStore() {
        if($code = Mage::getSingleton("adminhtml/config_data")->getStore()) {
            return Mage::getModel("core/store")->load($code);
        }
        elseif($code = Mage::getSingleton("adminhtml/config_data")->getWebsite()) {
            $websiteId = Mage::getModel("core/website")->load($code)->getId();

            return Mage::app()->getWebsite($websiteId)->getDefaultStore();
        }

        return Mage::app()->getStore();
    }
}