<?php

class Crossroads_Fees_Block_Amounts_Array extends Mage_Adminhtml_Block_System_Config_Form_Field_Array_Abstract {
    protected $paymentMethods = [];

    protected $currentStore = null;

    public function __construct() {
        $helper = Mage::helper("crossroads_fees");

        $this->currentStore   = $helper->getStore();
        $this->paymentMethods = Mage::getModel("payment/config")->getAllMethods($this->currentStore);

        $this->addColumn("payment_method", [
            "label" => $helper->__("Payment method"),
            "style" => "width:300px"
        ]);

        parent::__construct();

        $this->setTemplate("crossroads_fees/amounts_array.phtml");
    }

    public function mkGridId() {
        return $this->getHtmlId() ? $this->getHtmlId() : '_' . uniqid();
    }

    public function getBaseCurrencyCode() {
        return $this->currentStore->getBaseCurrencyCode();
    }

    public function getArrayRows() {
        return array_values(array_map(function($payment) {
            return [
                "code"  => $payment->getCode(),
                "title" => $payment->getTitle()
            ];
        }, $this->paymentMethods));
    }

    public function isSelected($code) {
        $values = $this->getValues();

        return array_key_exists($code, $values) && array_key_exists("enabled", $values[$code]) && strtolower(trim($values[$code]["enabled"])) === "on";
    }

    public function isSkipOnZeroSubtotal($code) {
        $values = $this->getValues();

        return array_key_exists($code, $values) && array_key_exists("skip_on_zero_subtotal", $values[$code]) ? $values[$code]["skip_on_zero_subtotal"] : "";
    }

    public function getValue($code) {
        $values = $this->getValues();

        return array_key_exists($code, $values) && array_key_exists("amount", $values[$code]) ? $values[$code]["amount"] : "";
    }

    public function getTitle($code) {
        $values = $this->getValues();

        return array_key_exists($code, $values) && array_key_exists("title", $values[$code]) ? $values[$code]["title"] : "";
    }

    public function getValues() {
        $v = $this->getElement()->getValue();

        if(!is_array($v)) {
            return [];
        }

        return $v;
    }
}
