<?php

class Crossroads_Fees_Model_Observer extends Mage_Core_Model_Abstract {
    /**
     * Observes `crossroads_api_quote_post_data_prepare` to add payment fee information.
     *
     * @param  Varien_Event_Observer
     */
    public function quotePostDataPrepare(Varien_Event_Observer $observer) {
        $quote  = $observer->getQuote();
        $totals = $observer->getTotals();
        $data   = $observer->getPreparedData();

        $summary = $data->getData("summary");

        $summary["paymentFee"]        = array_key_exists("payment_fee", $totals) ? $totals["payment_fee"]->getValueInclTax() : 0;
        $summary["paymentFeeExclTax"] = array_key_exists("payment_fee", $totals) ? $totals["payment_fee"]->getValueExclTax() : 0;
        $summary["paymentFeeTitle"]   = array_key_exists("payment_fee", $totals) ? $totals["payment_fee"]->getTitle() : 0;

        $data->setData("summary", $summary);

        return $this;
    }

    /**
     * Observer listening to `sales_order_invoice_save_after` to update payment fee amount invoiced in order.
     *
     * @param  Varien_Event_Observer
     */
    public function invoiceSaveAfter(Varien_Event_Observer $observer) {
        $invoice = $observer->getInvoice();
        $order   = $invoice->getOrder();

        if($invoice->getBasePaymentFeeAmount()) {
            $order->setPaymentFeeAmountInvoiced($order->getPaymentFeeAmountInvoiced() + $invoice->getPaymentFeeAmount());
            $order->setBasePaymentFeeAmountInvoiced($order->getBasePaymentFeeAmountInvoiced() + $invoice->getBasePaymentFeeAmount());
        }

        return $this;
    }

    /**
     * Observer listening to `sales_order_creditmemo_save_after` to update payment fee amount refunded in order.
     *
     * @param  Varien_Event_Observer
     */
    public function creditmemoSaveAfter(Varien_Event_Observer $observer) {
        $creditmemo = $observer->getCreditmemo();
        $order      = $creditmemo->getOrder();

        if($creditmemo->getBasePaymentFeeAmount()) {
            $order->setPaymentFeeAmountRefunded($order->getPaymentFeeAmountRefunded() + $creditmemo->getPaymentFeeAmount());
            $order->setBasePaymentFeeAmountRefunded($order->getBasePaymentFeeAmountRefunded() + $creditmemo->getBasePaymentFeeAmount());
        }

        return $this;
    }
}

