<?php
// Copied from Magento 1.9.2.4 app/code/core/Mage/Tax/Model/Calculation.php

class Crossroads_Fees_Model_Calculation extends Mage_Tax_Model_Calculation
{
    /**
     * Get calculation tax rate by specific request
     *
     * @param   Varien_Object $request
     * @return  float
     */
    public function getRate($request)
    {
        if (!$request->getCountryId() || !$request->getCustomerClassId() || !$request->getProductClassId()) {
            return 0;
        }

        // We just need to make sure we do not try to use the custom tax classes normally
        if(Mage::helper("crossroads_fees/tax")->isCustomTaxClassId($request->getProductClassId())) {
            throw new Mage_Exception("Weighted average tax class id on a product included in subtotal");
        }

        return parent::getRate($request);
    }
}
