<?php

/**
 * Override class for Mage_Tax_Helper_Data which adds the applied tax for payment methods
 * in getCalculatedTaxes.
 */
class Crossroads_Fees_Helper_Tax_Data extends Mage_Tax_Helper_Data {
    /**
     * Get calculated taxes for each tax class, modified to add payment method tax.
     *
     * This method returns array with format:
     * array(
     *  $index => array(
     *      'tax_amount'        => $taxAmount,
     *      'base_tax_amount'   => $baseTaxAmount,
     *      'hidden_tax_amount' => $hiddenTaxAmount,
     *      'title'             => $title,
     *      'percent'           => $percent
     *  )
     * )
     *
     * @param Mage_Sales_Model_Order $source
     * @return array
     */
    public function getCalculatedTaxes($source) {
        // We do the same as the original getCalculatedTaxes(), check if we have a current
        // instance, and in that case we just bypass this extra addition since we have it
        // cached.
        if ($this->_getFromRegistry('current_invoice')) {
            $current = $this->_getFromRegistry('current_invoice');
        } elseif ($this->_getFromRegistry('current_creditmemo')) {
            $current = $this->_getFromRegistry('current_creditmemo');
        } else {
            $current = $source;
        }

        $taxes = parent::getCalculatedTaxes($source);

        if($source->getBasePaymentFeeTaxAmount() && $current != $source) {
            $taxes[] = [
                "tax_amount"      => $source->getPaymentFeeTaxAmount(),
                "base_tax_amount" => $source->getBasePaymentFeeTaxAmount(),
                "title"           => $this->__("Payment Fee (%s)", $source->getPaymentFeeTitle()),
                "percent"         => $source->getPaymentFeeAmount() > 0 ? $source->getBasePaymentFeeTaxAmount() / $source->getPaymentFeeAmount() * 100 : null
            ];
        }

        return $taxes;
    }
}
