<?php

class Crossroads_Fees_Block_Order_Total extends Mage_Core_Block_Template {
    public function initTotals() {
        $order = $this->getParentBlock()->getSource();

        if ($order->getBasePaymentFeeAmount() > 0) {
            $this->getParentBlock()->addTotal(new Varien_Object([
                "code"       => "payment_fee",
                "value"      => $order->getPaymentFeeAmount() + $order->getPaymentFeeTaxAmount(),
                "base_value" => $order->getBasePaymentFeeAmount() + $order->getBasePaymentFeeTaxAmount(),
                "label"      => $this->__("Payment Fee (%s)", $order->getPaymentFeeTitle()),
            ]));
        }
    }
}
