<?php
// Copied from Magento 1.9.2.4 app/code/core/Mage/Tax/Model/Sales/Total/Quote/Tax.php

class Crossroads_Fees_Model_Sales_Total_Quote_Tax extends Mage_Tax_Model_Sales_Total_Quote_Tax
{
    /**
     * Tax caclulation for shipping price
     *
     * @param   Mage_Sales_Model_Quote_Address $address
     * @param   Varien_Object $taxRateRequest
     * @return  Mage_Tax_Model_Sales_Total_Quote
     */
    protected function _calculateShippingTax(Mage_Sales_Model_Quote_Address $address, $taxRateRequest)
    {
        $taxRateRequest->setProductClassId($this->_config->getShippingTaxClass($this->_store));

        // MODIFIED
        $crossroadsFeesTaxRates = null;
        if(Mage::helper("crossroads_fees/tax")->isCustomTaxClassId($taxRateRequest->getProductClassId())) {
            list($rate, $crossroadsFeesTaxRates) = Mage::helper("crossroads_fees/tax")->getTaxRate(
                Crossroads_Fees_Helper_Tax::TYPE_SHIPPING,
                $address,
                $taxRateRequest
            );
        }
        else {
            // Original fallback
            $rate = $this->_calculator->getRate($taxRateRequest);
        }
        // END MODIFICATION

        $inclTax = $address->getIsShippingInclTax();

        $address->setShippingTaxAmount(0);
        $address->setBaseShippingTaxAmount(0);
        $address->setShippingHiddenTaxAmount(0);
        $address->setBaseShippingHiddenTaxAmount(0);

        // MODIFIED
        $appliedRates = $crossroadsFeesTaxRates ?: $this->_calculator->getAppliedRates($taxRateRequest);
        // END MODIFICATION

        if ($inclTax) {
            $this->_calculateShippingTaxByRate($address, $rate, $appliedRates);
        } else {
            foreach ($appliedRates as $appliedRate) {
                $taxRate = $appliedRate['percent'];
                $taxId = $appliedRate['id'];
                $this->_calculateShippingTaxByRate($address, $taxRate, array($appliedRate), $taxId);
            }
        }
        return $this;
    }
}
