<?php

/**
 * Class responsible for adding payment fee to creditmemo refunds.
 */
class Crossroads_Fees_Model_Sales_Order_Total_Creditmemo_Paymentfee extends Mage_Sales_Model_Order_Creditmemo_Total_Abstract {
    public function collect(Mage_Sales_Model_Order_Creditmemo $creditmemo) {
        $order = $creditmemo->getOrder();

        // Refund the difference between already refunded and invoiced
        $amount     = $order->getPaymentFeeAmountInvoiced() - $order->getPaymentFeeAmountRefunded();
        $baseAmount = $order->getBasePaymentFeeAmountInvoiced() - $order->getBAsePaymentFeeAmountRefunded();

        $creditmemo->setGrandTotal($creditmemo->getGrandTotal() + $amount);
        $creditmemo->setBaseGrandTotal($creditmemo->getBaseGrandTotal() + $baseAmount);

        // Make sure we also add the specific amounts and the description
        $creditmemo->setPaymentFeeAmount($amount);
        $creditmemo->setBasePaymentFeeAmount($baseAmount);
        $creditmemo->setPaymentFeeTitle($order->getPaymentFeeTitle());

        return $this;
    }
}
