<?php

/**
 * Data source which lists product tax classes with the addition of an option for weighted average
 * based on subtotal.
 *
 * NOTE: Should only be used for fees calculated after subtotal.
 */
class Crossroads_Fees_Model_System_Config_Source_Shipping_Taxclass extends Mage_Adminhtml_Model_System_Config_Source_Shipping_Taxclass
{
    public function toOptionArray()
    {
        $options = parent::toOptionArray();

        array_push($options, [
            "value" => Crossroads_Fees_Helper_Tax::WEIGHTED_AVERAGE_TAX_CLASS_ID,
            "label" => Mage::helper("crossroads_fees")->__("Weighted average subtotal rate")
        ]);

        array_push($options, [
            "value" => Crossroads_Fees_Helper_Tax::DOMINATING_TAX_CLASS_ID,
            "label" => Mage::helper("crossroads_fees")->__("Dominating subtotal rate")
        ]);

        array_push($options, [
            "value" => Crossroads_Fees_Helper_Tax::HIGHEST_RATE_TAX_CLASS_ID,
            "label" => Mage::helper("crossroads_fees")->__("Highest subtotal rate")
        ]);

        return $options;
    }
}
