<?php

/**
 * Class responsible for adding the fee amount to the invoices.
 */
class Crossroads_Fees_Model_Sales_Order_Total_Invoice_Paymentfee extends Mage_Sales_Model_Order_Invoice_Total_Abstract {
    public function collect(Mage_Sales_Model_Order_Invoice $invoice) {
        $order = $invoice->getOrder();

        // Just add the difference to the invoice
        $amount     = $order->getPaymentFeeAmount() - $order->getPaymentFeeAmountInvoiced();
        $baseAmount = $order->getBasePaymentFeeAmount() - $order->getBasePaymentFeeAmountInvoiced();

        $invoice->setGrandTotal($invoice->getGrandTotal() + $amount);
        $invoice->setBaseGrandTotal($invoice->getBaseGrandTotal() + $baseAmount);

        // Make sure we also add the specific amounts and the description
        $invoice->setPaymentFeeAmount($amount);
        $invoice->setBasePaymentFeeAmount($baseAmount);
        $invoice->setPaymentFeeTitle($order->getPaymentFeeTitle());

        return $this;
    }
}
