<?php

/**
 * Observer for Crossroads_Collector module, separate class to make sure we only include this when
 * the event is triggered.
 */
class Crossroads_Fees_Model_CollectorObserver extends Mage_Core_Model_Abstract {
    /**
     * Observes crossroads_collector_reserve_amount_post_add_articles event to add
     * the payment fee to the Collector invoice.
     *
     * @param  Varien_Event_Observer
     */
    public function reserveAmountPostAddArticles(Varien_Event_Observer $observer) {
        $order = $observer->getOrder();
        $rows  = $observer->getOrderRows();

        if($order->getBasePaymentFeeAmount() > 0) {
            $rows->append([
                "ArticleId"   => "payment_fee",
                "Description" => $order->getPaymentFeeTitle(),
                "Quantity"    => 1,
                "UnitPrice"   => $order->getBasePaymentFeeAmount() + $order->getBasePaymentFeeTaxAmount(),
                "VAT"         => $order->getBasePaymentFeeTaxAmount() / $order->getBasePaymentFeeAmount() * 100,
            ]);
        }
    }
}
