# Crossroads Fees module

A generic module for applying fees in checkout depending on chosen payment method.

## Requirements

* [Composer](https://getcomposer.org/download/)

## Composer.json

Add the following to your `composer.json`:

```
{
	"name": "Your project name",
	"description": "Your project description",
	"require": {
		"Crossroads_Fees": "dev-master",
		"magento-hackathon/magento-composer-installer": "*"
	},
	"repositories": [
		{
			"type": "vcs",
			"url":  "git@groot.crossroads.se:modules/Crossroads-Fees.git"
		}
	],
	"extra": {
		"magento-root-dir":      ".",
		"auto-append-gitignore": true
	}
}
```

## Configuration

### Price configuration

To correctly calculate prices in the returned data, configure the following settings to the
displayed values in Magento Admin -> `System` -> `Configuration` -> `Sales` -> `Tax`:

#### Price Display Settings:

* **Display Shipping Prices:** `Including and Excluding Tax`

#### Shopping Cart Display Settings *and* Orders, Invoices, Credit Memos Display Settings

* **Display Prices:** `Including and Excluding Tax`
* **Display Subtotal:** `Including and Excluding Tax`
* **Display Shipping Amount:** `Including and Excluding Tax`
* **Display Full Tax Summary:** `Yes`
* **Display Zero Tax Subtotal:** `Yes`

## Development

When this module is installed in a project Composer clones the git reposiotry into `vendor/Crossroads_Fees`. It will then create hard-links according to the `extra.map` specification inside of `composer.json` of the `Crossroads_Fees` package.

To modify and develop the `Crossroads_Fees` module, modify files inside of `vendor/Crossroads_Fees` instead of `app/code/local/Crossroads/Fees`. Then commit and push like normal inside of `vendor/Crossroads_Fees`.

## Troubleshooting

* Some files got messed up and a reinstall of the module is required:

  ```
  composer run-script post-install-cmd -vvv -- --redeploy
  ```
