<?php

$installer = $this;

$installer->startSetup();

$conn      = $installer->getConnection();
$fee_type  = [
    "type"      => Varien_Db_Ddl_Table::TYPE_DECIMAL,
    "nullable"  => false,
    "default"   => 0,
    "precision" => 10,
    "scale"     => 2,
];
$fee_title = [
    "type"     => Varien_Db_Ddl_Table::TYPE_TEXT,
    "nullable" => true,
    "length"   => 255,
    "comment"  => "Payment fee title for fee applied by Crossroads Fees module"
];

$conn->addColumn($this->getTable("sales/order"), "payment_fee_amount",               array_merge($fee_type, ["comment" => "Payment fee amount excluding tax applied by Crossroads Fees module"]));
$conn->addColumn($this->getTable("sales/order"), "payment_fee_amount_invoiced",      array_merge($fee_type, ["comment" => "Invoiced amount of payment fee excluding tax applied by Crossroads Fees module"]));
$conn->addColumn($this->getTable("sales/order"), "payment_fee_amount_refunded",      array_merge($fee_type, ["comment" => "Refunded amount of payment fee excluding tax applied by Crossroads Fees module"]));
$conn->addColumn($this->getTable("sales/order"), "payment_fee_tax_amount",           array_merge($fee_type, ["comment" => "Payment fee tax amount applied by Crossroads Fees module"]));
$conn->addColumn($this->getTable("sales/order"), "base_payment_fee_amount",          array_merge($fee_type, ["comment" => "Payment fee base currency amount excluding tax applied by Crossroads Fees module"]));
$conn->addColumn($this->getTable("sales/order"), "base_payment_fee_amount_invoiced", array_merge($fee_type, ["comment" => "Invoiced amount of payment fee base currency excluding tax applied by Crossroads Fees module"]));
$conn->addColumn($this->getTable("sales/order"), "base_payment_fee_amount_refunded", array_merge($fee_type, ["comment" => "Refunded amount of payment fee base currency excluding tax applied by Crossroads Fees module"]));
$conn->addColumn($this->getTable("sales/order"), "base_payment_fee_tax_amount",      array_merge($fee_type, ["comment" => "Payment fee base currency tax amount applied by Crossroads Fees module"]));
$conn->addColumn($this->getTable("sales/order"), "payment_fee_title", $fee_title);

$conn->addColumn($this->getTable("sales/quote_address"), "payment_fee_amount",          array_merge($fee_type, ["comment" => "Payment fee amount excluding tax applied by Crossroads Fees module"]));
$conn->addColumn($this->getTable("sales/quote_address"), "payment_fee_tax_amount",      array_merge($fee_type, ["comment" => "Payment fee tax amount applied by Crossroads Fees module"]));
$conn->addColumn($this->getTable("sales/quote_address"), "base_payment_fee_amount",     array_merge($fee_type, ["comment" => "Payment fee base currency amount excluding tax applied by Crossroads Fees module"]));
$conn->addColumn($this->getTable("sales/quote_address"), "base_payment_fee_tax_amount", array_merge($fee_type, ["comment" => "Payment fee base currency tax amount applied by Crossroads Fees module"]));
$conn->addColumn($this->getTable("sales/quote_address"), "payment_fee_title", $fee_title);

$conn->addColumn($this->getTable("sales/invoice"), "payment_fee_amount",      array_merge($fee_type, ["comment" => "Payment fee amount excluding tax applied by Crossroads Fees module"]));
$conn->addColumn($this->getTable("sales/invoice"), "base_payment_fee_amount", array_merge($fee_type, ["comment" => "Payment fee base currency amount excluding tax applied by Crossroads Fees module"]));
$conn->addColumn($this->getTable("sales/invoice"), "payment_fee_title", $fee_title);

$conn->addColumn($this->getTable("sales/creditmemo"), "payment_fee_amount",      array_merge($fee_type, ["comment" => "Payment fee amount excluding tax applied by Crossroads Fees module"]));
$conn->addColumn($this->getTable("sales/creditmemo"), "base_payment_fee_amount", array_merge($fee_type, ["comment" => "Payment fee base currency amount excluding tax applied by Crossroads Fees module"]));
$conn->addColumn($this->getTable("sales/creditmemo"), "payment_fee_title", $fee_title);

$installer->endSetup();
