<?php

class Crossroads_ExtendedMediaFiles_Model_Rewrite_Core_File_Validator_Image extends Mage_Core_Model_File_Validator_Image
{
    /**
     * Validation callback for checking is file is image
     *
     * @param  string $filePath Path to temporary uploaded file
     * @return null
     * @throws Mage_Core_Exception
     */

    public function validate($filePath)
    {
        $isEnabled = Mage::helper('crossroads_extendedmediafiles')->isEnabled();
        if ($isEnabled && mime_content_type($filePath) == 'application/pdf') {
            return null;
        } else {
            return parent::validate($filePath);
        }
    }
}