<?php

class Crossroads_ExtendedMediaFiles_Model_Rewrite_Cms_Wysiwyg_Images_Storage extends Mage_Cms_Model_Wysiwyg_Images_Storage
{
    /**
     * Create thumbnail for image and save it to thumbnails directory
     *
     * AAI CHANGES: don't bother resizing PDF files
     *
     * @param string $source Image path to be resized
     * @param bool $keepRation Keep aspect ratio or not
     * @return bool|string Resized filepath or false if errors were occurred
     */

    public function resizeFile($source, $keepRation = true)
    {
        $isEnabled = Mage::helper('Crossroads_ExtendedMediaFiles')->isEnabled();
        $mimeType = mime_content_type($source);
        if ($isEnabled && $mimeType == 'application/pdf') {
            return false;
        } else {
            return parent::resizeFile($source, $keepRation);
        }
    }
 }