<?php

class Crossroads_Email_Block_Order_Email_Itemgroups_Default extends Crossroads_Email_Block_Order_Email_Items_Default {

    private $setup = false;
    private $attribute;
    private $item_cache = [
        'grouped' => [],
        'ungrouped' => [],
        'virtual' => []
    ];

    public function getLabel(): string {
        $this->setup();
        return $this->attribute ? $this->attribute->getFrontendLabel() : '';
    }

    public function getGroups(): array {
        $this->setup();
        return array_keys($this->item_cache['grouped']);
    }

    public function getGroupItems(string $key): array {
        $this->setup();
        return empty($this->item_cache['grouped'][$key]) ? [] : $this->item_cache['grouped'][$key];
    }

    public function getUngroupedItems(): array {
        $this->setup();
        return $this->item_cache['ungrouped'];
    }

    public function getVirtualItems(): array {
        $this->setup();
        return $this->item_cache['virtual'];
    }

    public function getGroupCount(): int {
        return count($this->item_cache['grouped'])
            + !empty($this->item_cache['ungrouped'])
            + !empty($this->item_cache['virtual']);
    }

    public function getTranslation(string $key, array $attributes = []): string {
        $translation = Mage::getStoreConfig(
            "Email/itemgroup_translations/itemgroup_{$key}",
            $storeId = Mage::app()->getStore()->getStoreId()
        );
        return array_reduce(array_keys($attributes), function ($carry, $item) use($attributes) {
            return str_replace('{' . $item . '}', $attributes[$item], $carry);
        }, $translation);
    }

    private function setUp(): void {
        if ($this->setup) {
            return;
        }

        // Check for attribute
        if ($groupby = $this->getGroupby()) {
            $type = Mage::getModel('catalog/product')->getResource()->getTypeId();
            $this->attribute = Mage::getResourceModel('eav/entity_attribute_collection')
                ->setEntityTypeFilter($type)
                ->setCodeFilter($groupby)
                ->getFirstItem();
        }

        // Evaluate items into different sections
        foreach (parent::getItems() as $item) {
            $product = $item->getProduct();
            $product->load($product->getId());

            if (empty($product)) {
                continue;
            }
            if ($product->isConfigurable()) {
                // If configurable, locate the child to use for evaluation
                $children = $item->getChildrenItems();
                $child = array_shift($children);
                if ($child) {
                    $product = $child->getProduct();
                    $product->load($product->getId());
                }
            }
            if ($product->isVirtual()) {
                $this->item_cache['virtual'][] = $item;
                continue;
            }
            if (empty($this->attribute)) {
                $this->item_cache['ungrouped'][] = $item;
                continue;
            }
            switch ($this->attribute->getBackendType()) {
                case 'datetime':
                    $value = substr($product->getData($groupby), 0, 10); // Only date part
                    break;
                default:
                    $value = trim($product->getData($groupby));
            }
            if (empty($value)) {
                $this->item_cache['ungrouped'][] = $item;
                continue;
            }
            $this->item_cache['grouped'][$value][] = $item;
        }
        ksort($this->item_cache['grouped'], SORT_NATURAL | SORT_FLAG_CASE);
        $this->setup = true;
    }
}
