<?php

class Crossroads_Email_Block_Order_Email_Totals_Awardit extends Crossroads_Email_Block_Order_Email_Totals_Default {
  public function toPrintValue($item) {
    $points = $item->getPointsRowPoints();
    $cash = $item->getRowTotalInclTax() - ($item->getPointsRowTotal() + $item->getPointsRowTaxTotal());

    return Mage::helper("crossroads_email")->formatPriceSplit($points, $cash);
  }

  public function subtotal() {
    return $this->getOrder()->getPointsPoints();
  }

  public function formattedSubtotal() {
    return $this->formatPoints($this->subtotal());
  }

  public function shipment() {
    return $this->getOrder()->getPointsShippingValue();
  }

  public function formattedShipment() {
    return $this->formatPoints($this->shipment()  || 0);
  }

  public function grandTotal() {
    return $this->getOrder()->getPointsPoints();
  }

  public function formattedGrandTotal() {
    return $this->formatPoints($this->grandTotal());
  }
}
