<?php

class Crossroads_Email_Helper_Data extends Mage_Core_Helper_Abstract {
  public function formatPoints($p) {
    $storeId = Mage::app()->getStore()->getStoreId();
    $pointsTranslation = strtolower(Mage::getStoreConfig('Email/translations/translation_points', $storeId));

    return number_format($p, 0, ",", " ") . " " . $pointsTranslation;
  }

  public function formatPrice($p) {
    $currency_code = Mage::app()->getStore()->getCurrentCurrencyCode();
    $currency_symbol = Mage::app()->getLocale()->currency($currency_code)->getSymbol();

    return str_replace(",00", "", number_format($p, 2, ",", " ")) . " " . $currency_symbol;
  }

  public function formatPriceSplit($points, $cash) {
    if ($points > 0 && $cash > 0) {
      return $this->formatPoints($points) . " " . $h->__("and") . " " . $this->formatPrice($cash);
    }

    if ($points > 0) {
      return $this->formatPoints($points);
    }

    if ($cash > 0) {
      return $this->formatPrice($cash);
    }

    return $this->formatPoints(0);
  }
}
