<?php

class Crossroads_Email_Block_Order_Email_Paymentinfo_Default extends Mage_Sales_Block_Order_Totals {
  public function paymentSplit() {
    return $this->formatPrice($this->getOrder()->getGrandTotal());
  }

  public function formatPrice($p) {
    return Mage::helper("crossroads_email")->formatPrice($p);
  }

  public function formatPoints($p) {
    return Mage::helper("crossroads_email")->formatPoints($p);
  }

  public function paymentTitle() {
    $order = $this->getOrder();
    $payment = $order->getPayment();

    if ($payment->getMethod() === "Crossroads_Stripe_PaymentIntents") {
      $paymentInfo = $payment->getAdditionalInformation();

      if ($paymentInfo) {
        $paymentInfoData = json_decode($paymentInfo["intent"], true);

        if ($paymentInfoData) {
          $paymentMethodDetails = $paymentInfoData["charges"]["data"][0]["payment_method_details"];

          if ($paymentMethodDetails["type"] == "card") {
            return implode(" ", [
              ucfirst($paymentMethodDetails["card"]["brand"]),
              "****",
              "****",
              "****",
              $paymentMethodDetails["card"]["last4"]
            ]);
          }
        }
      }
    }

    if ($payment->getMethod() === "free" && $order->getPointsType()) {
      $provider = Mage::helper("points_core")->getTypeProvider($order->getPointsType());

      if($provider) {
        return ucfirst($provider->getLabel($order->getStore()));
      }
    }

    return $payment->getMethodInstance()->getTitle();
  }

  public function formattedCreatedAt() {
    return date("Y-m-d", strtotime($this->getOrder()->getCreatedAt()));
  }

  public function pointsPayed() {
    return null;
  }

  public function getRate() {
    return null;
  }

  public function getCashTaxRates() {
    $cashPayed = $this->getOrder()->getGrandTotal();
    $taxRates = $this->getOrder()->getFullTaxInfo();

    foreach ($taxRates as $key => $taxRate) {
      $taxRates[$key]["amount"] = $cashPayed * (1 - 1 / (1 + $taxRate["percent"] / 100));
    }

    return $taxRates;
  }
}
