<?php

class Crossroads_Email_Block_Order_Email_Paymentinfo_Default extends Mage_Sales_Block_Order_Totals {
  public function paymentSplit() {
    return $this->formatPrice($this->getOrder()->getGrandTotal());
  }

  public function formatPrice($p) {
    return Mage::helper("crossroads_email")->formatPrice($p);
  }

  public function formatPoints($p) {
    return Mage::helper("crossroads_email")->formatPoints($p);
  }

  public function paymentTitle() {
    return $this->getOrder()->getPayment()->getMethodInstance()->getTitle();
  }

  public function formattedCreatedAt() {
    return date("Y-m-d", strtotime($this->getOrder()->getCreatedAt()));
  }

  public function pointsPayed() {
    return null;
  }

  public function getRate() {
    return null;
  }

  public function getCashTaxRates() {
    $cashPayed = $this->getOrder()->getGrandTotal();
    $taxRates = $this->getOrder()->getFullTaxInfo();

    foreach ($taxRates as $rate) {
      $rate["amount"] = ceil($cashPayed * ($rate["percent"] / 100));
    }

    return $taxRates;
  }
}
