<?php

class Crossroads_Email_Block_Order_Email_Totals_Default extends Mage_Sales_Block_Order_Totals {
  public function formatPrice($p) {
    return Mage::helper("crossroads_email")->formatPrice($p);
  }

  public function formatPoints($p) {
    return Mage::helper("crossroads_email")->formatPoints($p);
  }

  public function toPrintValue($v) {
    return $this->formatPrice($v);
  }

  public function subtotal() {
    return $this->getOrder()->getSubtotalInclTax();
  }

  public function formattedSubtotal() {
    return $this->formatPrice($this->subtotal());
  }

  public function discount() {
    return -$this->getOrder()->getDiscountAmount();
  }

  public function formattedDiscount() {
    return $this->formatPrice($this->discount());
  }

  public function paymentFee() {
    return $this->getOrder()->getDiscountAmount();
  }

  public function formattedPaymentFee() {
    return $this->formatPrice($this->paymentFee());
  }

  public function shipment() {
    return $this->getOrder()->getShippingAmount() +
           $this->getOrder()->getShippingTaxAmount() -
           $this->getOrder()->getShippingDiscountAmount();
  }

  public function formattedShipment() {
    return $this->formatPrice($this->shipment());
  }

  public function grandTotal() {
    return $this->getOrder()->getGrandTotal();
  }

  public function formattedGrandTotal() {
    return $this->formatPrice($this->grandTotal());
  }
}
