<?php

class Crossroads_Email_Block_Order_Email_Totals_Scandic extends Crossroads_Email_Block_Order_Email_Totals_Default {
  public function toPoints($p) {
    $rate = Mage::helper("scandic")->getRate(Mage::app()->getStore())

    return $p * $rate;
  }

  public function toPrintValue($v) {
    return $this->formatPoints($this->toPoints($v));
  }

  public function subtotal() {
    return $this->toPoints($this->getOrder()->getSubtotalInclTax());
  }

  public function formattedSubtotal() {
    return $this->formatPoints($this->subtotal());
  }

  public function discount() {
    return $this->toPoints(-$this->getOrder()->getDiscountAmount());
  }

  public function formattedDiscount() {
    return $this->formatPoints($this->discount());
  }

  public function paymentFee() {
    return $this->toPoints($this->getOrder()->getDiscountAmount());
  }

  public function formattedPaymentFee() {
    return $this->formatPoints($this->paymentFee());
  }

  public function shipment() {
    return $this->toPoints(
      $this->getOrder()->getShippingAmount() +
      $this->getOrder()->getShippingTaxAmount() -
      $this->getOrder()->getShippingDiscountAmount()
    );
  }

  public function formattedShipment() {
    return $this->formatPoints($this->shipment());
  }

  public function grandTotal() {
    return $this->toPoints($this->getOrder()->getGrandTotal()) + $this->getOrder()->getScandicPoints();
  }

  public function formattedGrandTotal() {
    return $this->formatPoints($this->grandTotal());
  }
}
