<?php

class Crossroads_Email_TestController extends Mage_Core_Controller_Front_Action
{
    public function indexAction() {
        $template_id = $this->getRequest()->getParam("template");
        $order_id    = $this->getRequest()->getParam("order");
        $variables   = $this->getRequest()->getParam("variables");

        $order         = Mage::getModel('sales/order')->load($order_id);
        $emailTemplate = Mage::getModel('core/email_template')->load($template_id);

        $emailTemplateVars = explode(",", $variables);

        if (!empty($order_id)) {
            $emailTemplateVars['order'] = $order;
            $store = $order->getStore();

            $paymentBlock = Mage::helper('payment')->getInfoBlock($emailTemplateVars['order']->getPayment())->setIsSecureMode(true);
            $paymentBlock->getMethod()->setStore($store);

            $emailTemplateVars['payment_html'] = $paymentBlock->toHtml();
            Mage::app()->setCurrentStore($store); // Force shop to same as order
        }

        echo $emailTemplate->getProcessedTemplate($emailTemplateVars);
    }

    public function shipmentAction() {
        $template_id = $this->getRequest()->getParam("template");
        $order_id    = $this->getRequest()->getParam("order");
        $variables   = $this->getRequest()->getParam("variables");

        $order         = Mage::getModel('sales/order')->load($order_id);
        $emailTemplate = Mage::getModel('core/email_template')->load($template_id);

        $emailTemplateVars = explode(",", $variables);

        if (!empty($order_id)) {
            $emailTemplateVars['order'] = $order;
            $store = $order->getStore();

            $paymentBlock = Mage::helper('payment')->getInfoBlock($emailTemplateVars['order']->getPayment())->setIsSecureMode(true);
            $paymentBlock->getMethod()->setStore($store);

            $emailTemplateVars['payment_html'] = $paymentBlock->toHtml();
            Mage::app()->setCurrentStore($store); // Force shop to same as order
        }


        // if is shipping:
        if ($order->hasShipments()) {
          $emailTemplateVars["shipment"] = $order->getShipmentsCollection()->getFirstItem();
          echo $emailTemplate->getProcessedTemplate($emailTemplateVars);
        } else {
          echo "This order does not have a shipment";
        }
    }
}
