<?php

class Crossroads_Email_Block_Order_Email_Shipment_Items_Default extends Mage_Sales_Block_Order_Email_Shipment_Items {
    public function getItems() {
        /** @var Mage_Sales_Model_Order_Shipment */
        $shipment = $this->getShipment();
        $items = $shipment->getAllItems();

        return array_values(array_filter($items, function($item) {
            return !$item->getOrderItem()->getParentItem();
        }));
    }

    public function formatPrice($p) {
      return Mage::helper("crossroads_email")->formatPrice($p);
    }

    public function formatPoints($p) {
      return Mage::helper("crossroads_email")->formatPoints($p);
    }

    /**
     * override from Mage_Sales_Block_Items_Abstract
     * to pass blocks to children even for children
     * created using "addItemRender"
     */
    public function getItemRenderer($type)
    {
        $block = parent::getItemRenderer($type);

        $block->setChild("spacer", $this->getChild("spacer"));
        $block->setChild("separator", $this->getChild("separator"));

        return $block;
    }
}
