<?php

class Crossroads_Email_Block_Order_Email_Totals_Scandic extends Crossroads_Email_Block_Order_Email_Totals_Default {
  public function shipment() {
    return $this->getOrder()->getPointsShippingValue();
  }

  public function discount() {
    return $this->getOrder()->getPointsDiscountValue() + $this->getOrder()->getPointsDiscountTaxValue();
  }

  public function formattedShipment() {
    return $this->formatPoints($this->shipment() || 0);
  }

  public function grandTotal() {
    return $this->getOrder()->getPointsPoints() + $this->getOrder()->getPointsTaxPoints();
  }

  public function formattedGrandTotal() {
    return $this->formatPoints($this->grandTotal());
  }
}
