# Email module

## How to test templates:
To test the template, nginx needs to be configured to let `email` get passed to magento, this is done per store.

Use this URL to try out order templates: `https://shop.example.tld/email/test?order=X&template=X`

Example: `https://vanilla.awarditstage.com/email/test?order=30912&template=3`

Use this URL to try out shipment templates: `https://shop.example.tld/email/test/shipment?order=X&template=X`

## How to create changes for new shops
Copy the Default.php files in the blocks and extend the default instead. Override the methods you like to customize.

`Note: The emailfolder in the templatesfolder need to be named crossroads_email, not only email`

If a block in the email needs to be overwritten, start by looking at where the current templatefile is located by turning on "Template Path Hints" in magento.<br />
If the path reads `frontend/base/default/template/crossroads_email/order/shipment/items.phtml`, <br />
the overriding file needs to be located in your crossroads_email/order/shipment folder and named items.phtml

## Templates

An incomplete list of email related templates.

### sales_email_order_items

Will group items in order item lists according to specified attribute code. 
Headers are specified in System > Configuration > Crossroads > Email.

Include the following in transaction email that should use it.
```
{{layout handle="sales_email_order_items" order=$order groupby="attribute_code"}} 
```
