<?php

class Crossroads_Email_Block_Order_Email_Paymentinfo_Scandic extends Crossroads_Email_Block_Order_Email_Paymentinfo_Default {
  public function paymentSplit() {
    $order = $this->getOrder();
    $points = $this->getOrder()->getPointsPoints() + $this->getOrder()->getPointsTaxPoints();
    $cash = $order->getGrandTotal();
    $h = Mage::helper("crossroads_email");

    return $this->formatPoints($points) . " " . $h->__("and") . " " . $this->formatPrice($cash);
  }

  public function paymentTitle() {
    $order = $this->getOrder();
    $paymentTitle = $order->getPayment()->getMethodInstance()->getTitle();
    $paymentMethod = $order->getPayment()->getMethodInstance()->getCode();

    if ($order->getPayment()->getMethod() == "Crossroads_Stripe_PaymentIntents") {
      $paymentInfo = $this->getOrder()->getPayment()->getAdditionalInformation();

      if ($paymentInfo) {
        $paymentInfo = json_decode($paymentInfo["intent"], true);

        if ($paymentInfo) {
          $paymentMethodDetails = $paymentInfo["charges"]["data"][0]["payment_method_details"];
          $paymentMethod = $paymentMethodDetails["type"];

          if ($paymentMethod == "card") {
            $cardType = ucfirst($paymentMethodDetails["card"]["brand"]);
            $last4 = $paymentMethodDetails["card"]["last4"];
          }

          return $cardType . " **** **** **** " . $last4;
        }
      }
    }

    if ($paymentMethod === "free") {
      $paymentTitle = Mage::helper("crossroads_email")->__("Points payment");
    }

    return $paymentTitle;
  }

  public function pointsPayed() {
    $order = $this->getOrder();
    return $this->getOrder()->getPointsPoints() + $this->getOrder()->getPointsTaxPoints();
  }
}
