<?php

class Crossroads_Email_Block_Order_Email_Totals_Folkspel extends Crossroads_Email_Block_Order_Email_Totals_Default {
  public function toPoints($p) {
    $rate = $this->getOrder()->getFolkspelRate();

    return $p * $rate;
  }

  public function subtotal() {
    return $this->toPoints($this->getOrder()->getSubtotalInclTax());
  }

  public function discount() {
    return $this->toPoints(-$this->getOrder()->getDiscountAmount());
  }

  public function paymentFee() {
    return $this->getOrder()->getDiscountAmount();
  }

  public function shipment() {
    return $this->toPoints(
      $this->getOrder()->getShippingAmount() +
      $this->getOrder()->getShippingTaxAmount() -
      $this->getOrder()->getShippingDiscountAmount()
    );
  }

  public function grandTotal() {
    return $this->toPoints($this->getOrder()->getGrandTotal()) + $this->getOrder()->getFolkspelPoints();
  }
}
