<?php

class Crossroads_Email_Block_Order_Email_Totals_Default extends Mage_Sales_Block_Order_Totals {
  public function formatPrice($p) {
    return Mage::helper("crossroads_email")->formatPrice($p);
  }

  public function formatPoints($p) {
    return Mage::helper("crossroads_email")->formatPoints($p);
  }

  public function subtotal() {
    return $this->getOrder()->getSubtotalInclTax();
  }

  public function discount() {
    return -$this->getOrder()->getDiscountAmount();
  }

  public function paymentFee() {
    return $this->getOrder()->getDiscountAmount();
  }

  public function shipment() {
    return $this->getOrder()->getShippingAmount() +
           $this->getOrder()->getShippingTaxAmount() -
           $this->getOrder()->getShippingDiscountAmount();
  }

  public function grandTotal() {
    return $this->getOrder()->getGrandTotal();
  }
}
