<?php

class Crossroads_Email_IndexController extends Mage_Core_Controller_Front_Action
{
    public function testAction()
    {
        $template_id = $this->getRequest()->getParam("template");
        $order_id    = $this->getRequest()->getParam("order");
        $variables   = $this->getRequest()->getParam("variables");

        $emailTemplate = Mage::getModel('core/email_template')->load($template_id);

        $emailTemplateVars = explode(",", $variables);

        if (!empty($order_id)) {
            $emailTemplateVars['order'] = Mage::getModel('sales/order')->load($order_id);

            $paymentBlock = Mage::helper('payment')->getInfoBlock($emailTemplateVars['order']->getPayment())->setIsSecureMode(true);
            $paymentBlock->getMethod()->setStore(Mage::app()->getStore());

            $emailTemplateVars['payment_html'] = $paymentBlock->toHtml();
        }

        echo $emailTemplate->getProcessedTemplate($emailTemplateVars);
    }
}
