<?php

$installer = $this;

$installer->startSetup();

$table = $conn->newTable($installer->getTable("Crossroads_Elasticsearch/attribute_status"))
    ->addColumn('attribute_id', Varien_Db_Ddl_Table::TYPE_SMALLINT, null, array(
        "unsigned" => true,
        "nullable" => false,
        "primary"  => true,
    ))
    ->addColumn("keyword_field", Varien_Db_Ddl_Table::TYPE_BOOLEAN, null, [
        "nullable" => false,
        "default"  => false,
    ])
    ->addColumn("trigram_field", Varien_Db_Ddl_Table::TYPE_BOOLEAN, null, [
        "nullable" => false,
        "default"  => false,
    ])
    ->addColumn("completion_field", Varien_Db_Ddl_Table::TYPE_BOOLEAN, null, [
        "nullable" => false,
        "default"  => false,
    ])
    ->addColumn("locale_fields", Varien_Db_Ddl_Table::TYPE_TEXT, null, [
        "nullable" => false,
        "default"  => "",
    ])
    ->addForeignKey(
        $installer->getFkName(
            "Crossroads_Elasticsearch/attribute_status",
            "attribute_id",
            "eav/attribute",
            "attribute_id"
        ),
        "attribute_id", $installer->getTable("eav/attribute"), "attribute_id",
        Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE)
    ->setOption("type", "InnoDB")
    ->setOption("charset", "utf8");

$conn->createTable($table);

$installer->endSetup();
