<?php

class Crossroads_Elasticsearch_Model_Query_Parser {
    protected $input      = "";
    protected $attrs      = [];
    protected $localeCode = "en_US";

    public function setAttributes($attrs) {
        $this->attrs = $attrs;

        return $this;
    }

    public function setLocaleCode($locale) {
        $this->localeCode = $locale;

        return $this;
    }

    public function parseQuery($input) {
        // TODO: Parse the query!
        $p = new Crossroads_Elasticsearch_Model_QueryParser();

        return [ "query_string" => [
            "query"                => $p->repair($input),
            "fields"               => $this->getSearchFields(),
            // TODO: Configurable?
            "fuzzy_prefix_length"  => 3,
            // TODO: Configurable?
            "phrase_slop"          => 1,
            // TODO: Configurable?
            "minimum_should_match" => "100%",
            // TODO: Configurable?
            "default_operator"     => "AND",
            "locale"               => $this->localeCode,
        ] ];
    }

    protected function getSearchFields() {
        return call_user_func_array("array_merge", array_values(array_map(function($a) {
            return $a->getSearchFields($this->localeCode);
        }, $this->attrs)));
    }
}
