<?php

class Crossroads_Elasticsearch_AttributesController extends Crossroads_API_Controller_Resource {
    public function getAll() {
        return [404];
    }

    public function getItem($id) {
        $params = array_filter(array_map("trim", explode(",", $id)));

        if (empty($params)) {
            throw Crossroads_API_ResponseException::create(400, "Missing attribute parameter list.");
        }

        $store       = Mage::app()->getStore();
        $helper      = Mage::helper("Crossroads_Elasticsearch");
        $indexName   = $store->getConfig(Crossroads_Elasticsearch_Helper_Data::CONFIG_PRODUCT_INDEX);
        $attributes  = Mage::getResourceModel("Crossroads_Elasticsearch/attribute")->getFilterableProductAttributes($store);
        $filterAttrs = array_filter($attributes, function($a) { return $a->getIsFilterable() && $a->hasKeywordField(); });

        $aggs   = [];

        $wrong   = array_diff($params, array_map(function($a) {
            return $a->getCode();
        }, array_filter($filterAttrs, function($a) {
            return $a->hasKeywordField();
        })));

        if( ! empty($wrong)) {
            throw Crossroads_API_ResponseException::create(400, sprintf("Unknown parameter keys '%s'.", implode("', '", $wrong)));
        }

        $q = $helper->createProductQuery($store, Crossroads_Elasticsearch_Model_Query_Products::VISIBILITY_CATALOG);

        foreach($filterAttrs as $attr) {
            if(in_array($attr->getCode(), $params) && $attr->hasKeywordField()) {
                $aggs[$attr->getCode()] = [ "terms" => [ "field" => $attr->getKeywordField(), "size" => 100 ] ];
            }
        }

        $client = $helper->createClient();

        $response = $client->search([
            "index" => $indexName,
            "type"  => "product",
            "body"  => [
                "size" => 0,
                "query" => $q->toRequest(),
                "aggs" => empty($aggs) ? new stdClass : $aggs,
            ],
        ]);

        return [200, array_map(function($a) {
            return array_map(function($b) {
                return [
                    "key"   => $b["key"],
                    "count" => $b["doc_count"],
                ];
            }, $a["buckets"]);
        }, $response["aggregations"])];
    }
}
